#include "General.h"
#include "RefillCostsMoney.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

float FractionOfTotalCost;
bool NoBasePowerDoubleCost;

#define GREEN "104,234,40"

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	Console_Input(buffer);
}

// Uses CMSGP if scripts verion supports it, otherwise uses PPAGE
void Page(int ID, const char* rgb_colour, const char *Format, ...)
{
	if ( (ID < 1) || (ID > 128) ) return;
	if (!Get_GameObj(ID)) return;

	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	float Version = Get_Client_Version(ID);

	if (Version < 2.9)
	{
		Console("PPAGE %d %s", ID, buffer);
	}
	else
	{
		Console("CMSGP %d %s %s", ID, rgb_colour, buffer);
	}
}

float Get_Refill_Cost(GameObject* purchaser, int CurrentHP, int MaxHP)
{
	// (Is_Base_Powered(base->Get_Player_Type()) ? 1.0f : 2.0f);
	float PresetCost = (float)Get_Cost(Commands->Get_Preset_Name(purchaser));
	float BasePowerMultiplier = 1.0f;

	int PurchaserTeam = Get_Team(Get_Player_ID(purchaser));
	if ( NoBasePowerDoubleCost && (Is_Base_Powered(PurchaserTeam) == false) )
	{
		BasePowerMultiplier = 2.0f;
	}

	return BasePowerMultiplier * PresetCost * ((float)(MaxHP - CurrentHP) / (float)MaxHP);
}

RefillCostsMoney::RefillCostsMoney()
{
	RegisterEvent(EVENT_GLOBAL_INI,this);
	RegisterEvent(EVENT_REFILL_HOOK,this);
}

RefillCostsMoney::~RefillCostsMoney()
{
	UnregisterEvent(EVENT_GLOBAL_INI,this);
	UnregisterEvent(EVENT_REFILL_HOOK,this);
}

void RefillCostsMoney::OnLoadGlobalINISettings(INIClass *SSGMIni)
{
	FractionOfTotalCost = SSGMIni->Get_Float("RefillCostsMoney", "FractionOfTotalCost", 0.3f);
	NoBasePowerDoubleCost = SSGMIni->Get_Bool("RefillCostsMoney", "NoBasePowerDoubleCost", true);
}
bool RefillCostsMoney::OnRefill(GameObject *purchaser)
{
	int MaxHP = (int)(Commands->Get_Max_Health(purchaser) + Commands->Get_Max_Shield_Strength(purchaser));
	int CurrentHP = (int)(Commands->Get_Health(purchaser) + Commands->Get_Shield_Strength(purchaser));
	
	if ( (MaxHP == 0) || (CurrentHP == 0) ) { return true; } // Avoid division by zero

	float RefillCost = Get_Refill_Cost(purchaser, CurrentHP, MaxHP);

	float Cost = RefillCost * FractionOfTotalCost;
	int PlayerID = Get_Player_ID(purchaser);
	
//	Console_Output("RefillCost = %f, Cost = %f\n", RefillCost, Cost);

	if ( (int)Cost == 0 ) return true; // If refill cost is zero don't page

	if ( Cost > Get_Money(PlayerID) )
	{
		Page(PlayerID, GREEN, "You don't have enough credits to purchase a refill, you need %.0f credits.", Cost);
		return false;
	}
	else
	{
		Page(PlayerID, GREEN, "Your refill cost you %.0f credits.", Cost);
		Commands->Give_Money(purchaser, -Cost, false);
	}
	return true;
}

RefillCostsMoney refillCostsMoney;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &refillCostsMoney;
}
